/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1986 - 2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
/*
 * Name:
 *	SPSuites.h
 *
 *
 * Purpose:
 *	Defines SP API Suites. 
 *
 * Distribution:
 *	PUBLIC
 *
 * Version history:
 *	1.0.0 4/1/1995	DL	First Version.
 *		Created by Adobe Systems Incorporated.
 */


#ifndef __SPSuites__
#define __SPSuites__


/*******************************************************************************
 **
 **	Imports
 **
 **/

#include "SPTypes.h"
#include "SPAccess.h"
#include "SPPlugs.h"
#include "SPStrngs.h"

#ifdef __cplusplus
extern "C" {
#endif


/*******************************************************************************
 **
 ** Constants
 **
 **/

#define kSPSuitesSuite				"SP Suites Suite"
#define kSPSuitesSuiteVersion		2

#define kSPLatestInternalVersion	0

#define kSPRuntimeSuiteList			((SPSuiteListRef)NULL)


/*******************************************************************************
 **
 ** Types
 **
 **/

typedef struct SPSuite *SPSuiteRef;
typedef struct SPSuiteList *SPSuiteListRef;
typedef struct SPSuiteListIterator *SPSuiteListIteratorRef;


/*******************************************************************************
 **
 ** Suite
 **
 **/

typedef struct SPSuitesSuite {

	SPAPI SPErr (*AllocateSuiteList)( SPStringPoolRef stringPool, SPPluginListRef plugins, SPSuiteListRef *suiteList );
	SPAPI SPErr (*FreeSuiteList)( SPSuiteListRef suiteList );

	SPAPI SPErr (*AddSuite)( SPSuiteListRef suiteList, SPPluginRef host, char *name, long apiVersion, long internalVersion, void *suiteProcs, SPSuiteRef *suite );
	SPAPI SPErr (*AcquireSuite)( SPSuiteListRef suiteList, char *name, long apiVersion, long internalVersion, void **suiteProcs );
	SPAPI SPErr (*ReleaseSuite)( SPSuiteListRef suiteList, char *name, long apiVersion, long internalVersion );

	SPAPI SPErr (*FindSuite)( SPSuiteListRef suiteList, char *name, long apiVersion, long internalVersion, SPSuiteRef *suite );

	SPAPI SPErr (*NewSuiteListIterator)( SPSuiteListRef suiteList, SPSuiteListIteratorRef *iter );
	SPAPI SPErr (*NextSuite)( SPSuiteListIteratorRef iter, SPSuiteRef *suite );
	SPAPI SPErr (*DeleteSuiteListIterator)( SPSuiteListIteratorRef iter );

	SPAPI SPErr (*GetSuiteHost)( SPSuiteRef suite, SPPluginRef *plugin );
	SPAPI SPErr (*GetSuiteName)( SPSuiteRef suite, char **name );
	SPAPI SPErr (*GetSuiteAPIVersion)( SPSuiteRef suite, long *version );
	SPAPI SPErr (*GetSuiteInternalVersion)( SPSuiteRef suite, long *version );
	SPAPI SPErr (*GetSuiteProcs)( SPSuiteRef suite, void **suiteProcs );
	SPAPI SPErr (*GetSuiteAcquireCount)( SPSuiteRef suite, long *count );

} SPSuitesSuite;


SPAPI SPErr SPAllocateSuiteList( SPStringPoolRef stringPool, SPPluginListRef plugins, SPSuiteListRef *suiteList );
SPAPI SPErr SPFreeSuiteList( SPSuiteListRef suiteList );

SPAPI SPErr SPAddSuite( SPSuiteListRef suiteList, SPPluginRef host, char *name, long apiVersion, long internalVersion, void *suiteProcs, SPSuiteRef *suite );
SPAPI SPErr SPAcquireSuite( SPSuiteListRef suiteList, char *name, long apiVersion, long internalVersion, void **suiteProcs );
SPAPI SPErr SPReleaseSuite( SPSuiteListRef suiteList, char *name, long apiVersion, long internalVersion );

SPAPI SPErr SPFindSuite( SPSuiteListRef suiteList, char *name, long apiVersion, long internalVersion, SPSuiteRef *suite );

SPAPI SPErr SPNewSuiteListIterator( SPSuiteListRef suiteList, SPSuiteListIteratorRef *iter );
SPAPI SPErr SPNextSuite( SPSuiteListIteratorRef iter, SPSuiteRef *suite );
SPAPI SPErr SPDeleteSuiteListIterator( SPSuiteListIteratorRef iter );

SPAPI SPErr SPGetSuiteHost( SPSuiteRef suite, SPPluginRef *plugin );
SPAPI SPErr SPGetSuiteName( SPSuiteRef suite, char **name );
SPAPI SPErr SPGetSuiteAPIVersion( SPSuiteRef suite, long *version );
SPAPI SPErr SPGetSuiteInternalVersion( SPSuiteRef suite, long *version );
SPAPI SPErr SPGetSuiteProcs( SPSuiteRef suite, void **suiteProcs );
SPAPI SPErr SPGetSuiteAcquireCount( SPSuiteRef suite, long *count );


/*******************************************************************************
 **
 **	Errors
 **
 **/

#include "SPErrorCodes.h"

#ifdef __cplusplus
}
#endif

#endif
